/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import soot.AnySubType;
import soot.Context;
import soot.G;
import soot.RefLikeType;
import soot.Type;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.ValNode;
import soot.toolkits.scalar.Pair;

public abstract class VarNode
extends ValNode
implements Comparable {
    protected Object variable;
    protected Map<SparkField, FieldRefNode> fields;
    protected int finishingNumber = 0;
    protected boolean interProcTarget = false;
    protected boolean interProcSource = false;
    protected int numDerefs = 0;

    public Context context() {
        return null;
    }

    public Collection<FieldRefNode> getAllFieldRefs() {
        if (this.fields == null) {
            return Collections.emptyList();
        }
        return this.fields.values();
    }

    public FieldRefNode dot(SparkField field) {
        return this.fields == null ? null : this.fields.get(field);
    }

    public int compareTo(Object o) {
        VarNode other = (VarNode)o;
        if (other.finishingNumber == this.finishingNumber && other != this) {
            G.v().out.println("This is: " + this + " with id " + this.getNumber() + " and number " + this.finishingNumber);
            G.v().out.println("Other is: " + other + " with id " + other.getNumber() + " and number " + other.finishingNumber);
            throw new RuntimeException("Comparison error");
        }
        return other.finishingNumber - this.finishingNumber;
    }

    public void setFinishingNumber(int i) {
        this.finishingNumber = i;
        if (i > this.pag.maxFinishNumber) {
            this.pag.maxFinishNumber = i;
        }
    }

    public Object getVariable() {
        return this.variable;
    }

    public void setInterProcTarget() {
        this.interProcTarget = true;
    }

    public boolean isInterProcTarget() {
        return this.interProcTarget;
    }

    public void setInterProcSource() {
        this.interProcSource = true;
    }

    public boolean isInterProcSource() {
        return this.interProcSource;
    }

    public boolean isThisPtr() {
        if (this.variable instanceof Pair) {
            Pair o = (Pair)this.variable;
            return o.isThisParameter();
        }
        return false;
    }

    VarNode(PAG pag, Object variable, Type t) {
        super(pag, t);
        if (!(t instanceof RefLikeType) || t instanceof AnySubType) {
            throw new RuntimeException("Attempt to create VarNode of type " + t);
        }
        this.variable = variable;
        pag.getVarNodeNumberer().add(this);
        this.setFinishingNumber(++pag.maxFinishNumber);
    }

    void addField(FieldRefNode frn, SparkField field) {
        if (this.fields == null) {
            this.fields = new HashMap<SparkField, FieldRefNode>();
        }
        this.fields.put(field, frn);
    }
}

