/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand.genericutil;

public abstract class Predicate<T> {
    public static final Predicate FALSE = new Predicate(){

        public boolean test(Object obj_) {
            return false;
        }
    };
    public static final Predicate TRUE = FALSE.not();

    public static <T> Predicate<T> truePred() {
        return TRUE;
    }

    public static <T> Predicate<T> falsePred() {
        return FALSE;
    }

    public abstract boolean test(T var1);

    public Predicate<T> not() {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T obj_) {
                return !originalPredicate.test(obj_);
            }
        };
    }

    public Predicate<T> and(final Predicate<T> conjunct_) {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T obj_) {
                return originalPredicate.test(obj_) && conjunct_.test(obj_);
            }
        };
    }

    public Predicate<T> or(final Predicate<T> disjunct_) {
        final Predicate originalPredicate = this;
        return new Predicate<T>(){

            @Override
            public boolean test(T obj_) {
                return originalPredicate.test(obj_) || disjunct_.test(obj_);
            }
        };
    }
}

