/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.validation.FieldRefValidator;
import soot.jimple.validation.IdentityStatementsValidator;
import soot.jimple.validation.IdentityValidator;
import soot.jimple.validation.InvokeArgumentValidator;
import soot.jimple.validation.JimpleTrapValidator;
import soot.jimple.validation.NewValidator;
import soot.jimple.validation.ReturnStatementsValidator;
import soot.jimple.validation.TypesValidator;
import soot.options.Options;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class JimpleBody
extends StmtBody {
    private static BodyValidator[] validators;

    private static synchronized BodyValidator[] getValidators() {
        if (validators == null) {
            validators = new BodyValidator[]{IdentityStatementsValidator.v(), TypesValidator.v(), ReturnStatementsValidator.v(), InvokeArgumentValidator.v(), FieldRefValidator.v(), NewValidator.v(), JimpleTrapValidator.v(), IdentityValidator.v()};
        }
        return validators;
    }

    JimpleBody(SootMethod m) {
        super(m);
    }

    JimpleBody() {
    }

    @Override
    public Object clone() {
        JimpleBody b = new JimpleBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    @Override
    public void validate() {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        this.validate(exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    @Override
    public void validate(List<ValidationException> exceptionList) {
        super.validate(exceptionList);
        boolean runAllValidators = Options.v().debug() || Options.v().validate();
        for (BodyValidator validator : JimpleBody.getValidators()) {
            if (!validator.isBasicValidator() && !runAllValidators) continue;
            validator.validate(this, exceptionList);
        }
    }

    public void validateIdentityStatements() {
        this.runValidation(IdentityStatementsValidator.v());
    }

    public void insertIdentityStmts() {
        int i = 0;
        for (Type t : this.getMethod().getParameterTypes()) {
            Local l = Jimple.v().newLocal("parameter" + i, t);
            this.getLocals().add(l);
            this.getUnits().addFirst(Jimple.v().newIdentityStmt(l, Jimple.v().newParameterRef(l.getType(), i)));
            ++i;
        }
        if (!this.getMethod().isStatic()) {
            Local l = Jimple.v().newLocal("this", RefType.v(this.getMethod().getDeclaringClass()));
            this.getLocals().add(l);
            this.getUnits().addFirst(Jimple.v().newIdentityStmt(l, Jimple.v().newThisRef((RefType)l.getType())));
        }
    }

    public Stmt getFirstNonIdentityStmt() {
        Iterator<Unit> it = this.getUnits().iterator();
        Unit o = null;
        while (it.hasNext() && (o = it.next()) instanceof IdentityStmt) {
        }
        if (o == null) {
            throw new RuntimeException("no non-id statements!");
        }
        return (Stmt)o;
    }
}

