/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp.internal;

import java.util.ArrayList;
import java.util.List;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.ExprSwitch;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class GDynamicInvokeExpr
extends AbstractInvokeExpr
implements DynamicInvokeExpr {
    protected ValueBox[] bsmArgBoxes;
    private SootMethodRef bsmRef;
    protected int tag;

    public GDynamicInvokeExpr(SootMethodRef bootStrapMethodRef, List<Value> bootstrapArgs, SootMethodRef methodRef, int tag, List args) {
        super(methodRef, new ValueBox[args.size()]);
        int i;
        this.bsmRef = bootStrapMethodRef;
        this.tag = tag;
        for (i = 0; i < args.size(); ++i) {
            this.argBoxes[i] = Grimp.v().newExprBox((Value)args.get(i));
        }
        for (i = 0; i < bootstrapArgs.size(); ++i) {
            this.bsmArgBoxes[i] = Grimp.v().newExprBox(bootstrapArgs.get(i));
        }
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedArgs = new ArrayList<Value>(this.getArgCount());
        for (int i = 0; i < this.getArgCount(); ++i) {
            clonedArgs.add(i, Grimp.cloneIfNecessary(this.getArg(i)));
        }
        ArrayList<Value> clonedBsmArgs = new ArrayList<Value>(this.getBootstrapArgCount());
        for (int i = 0; i < this.getBootstrapArgCount(); ++i) {
            clonedBsmArgs.add(i, this.getBootstrapArg(i));
        }
        return new GDynamicInvokeExpr(this.bsmRef, clonedBsmArgs, this.methodRef, this.tag, clonedArgs);
    }

    @Override
    public Value getBootstrapArg(int i) {
        return this.bsmArgBoxes[i].getValue();
    }

    @Override
    public int getBootstrapArgCount() {
        return this.bsmArgBoxes.length;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseDynamicInvokeExpr(this);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof GDynamicInvokeExpr) {
            GDynamicInvokeExpr ie = (GDynamicInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            for (ValueBox element : this.argBoxes) {
                if (element.getValue().equivTo(element.getValue())) continue;
                return false;
            }
            if (!this.methodRef.equals(ie.methodRef)) {
                return false;
            }
            return this.bsmRef.equals(ie.bsmRef);
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getMethod().equivHashCode();
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    @Override
    public List<Value> getBootstrapArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        for (ValueBox element : this.bsmArgBoxes) {
            l.add(element.getValue());
        }
        return l;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("dynamicinvoke");
        buffer.append(" \"");
        buffer.append(this.methodRef.name());
        buffer.append("\" <");
        buffer.append(SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()));
        buffer.append(">(");
        for (i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
        }
        buffer.append(") ");
        buffer.append(this.bsmRef.getSignature());
        buffer.append("(");
        for (i = 0; i < this.bsmArgBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.bsmArgBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        int i;
        up.literal("dynamicinvoke");
        up.literal(" \"" + this.methodRef.name() + "\" <" + SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()) + ">(");
        for (i = 0; i < this.argBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
        }
        up.literal(") ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        for (i = 0; i < this.bsmArgBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.bsmArgBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }
}

