/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.DoubleType;
import soot.FloatType;
import soot.Local;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.dexpler.Debug;
import soot.dexpler.DexTransformer;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CmpExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DexNumTransformer
extends DexTransformer {
    private boolean usedAsFloatingPoint;
    boolean doBreak = false;
    Local l = null;

    public static DexNumTransformer v() {
        return new DexNumTransformer();
    }

    @Override
    protected void internalTransform(final Body body, String phaseName, Map<String, String> options) {
        final LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(body);
        final LocalUses localUses = LocalUses.Factory.newLocalUses(body, localDefs);
        for (Local loc : this.getNumCandidates(body)) {
            Debug.printDbg("\n[num candidate] ", loc);
            this.usedAsFloatingPoint = false;
            List<Unit> defs = this.collectDefinitionsWithAliases(loc, localDefs, localUses, body);
            this.doBreak = false;
            for (Unit u : defs) {
                if (u instanceof DefinitionStmt) {
                    this.l = (Local)((DefinitionStmt)u).getLeftOp();
                }
                Debug.printDbg("    def  : ", u);
                Debug.printDbg("    local: ", this.l);
                u.apply(new AbstractStmtSwitch(){

                    @Override
                    public void caseAssignStmt(AssignStmt stmt) {
                        Value r = stmt.getRightOp();
                        if (r instanceof BinopExpr && !(r instanceof CmpExpr)) {
                            DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.examineBinopExpr(stmt);
                            DexNumTransformer.this.doBreak = true;
                        } else if (r instanceof FieldRef) {
                            DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.isFloatingPointLike(((FieldRef)r).getFieldRef().type());
                            DexNumTransformer.this.doBreak = true;
                        } else if (r instanceof NewArrayExpr) {
                            NewArrayExpr nae = (NewArrayExpr)r;
                            Type t = nae.getType();
                            Debug.printDbg("new array expr: ", nae, " type: ", t);
                            DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.isFloatingPointLike(t);
                            DexNumTransformer.this.doBreak = true;
                        } else if (r instanceof ArrayRef) {
                            ArrayRef ar = (ArrayRef)r;
                            Type arType = ar.getType();
                            Debug.printDbg("ar: ", r, " ", arType);
                            if (arType instanceof UnknownType) {
                                Type t = DexNumTransformer.this.findArrayType(localDefs, localUses, stmt, 0, Collections.<Unit>emptySet());
                                Debug.printDbg(" array type:", t);
                                DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.isFloatingPointLike(t);
                            } else {
                                DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.isFloatingPointLike(ar.getType());
                            }
                            DexNumTransformer.this.doBreak = true;
                        } else if (r instanceof CastExpr) {
                            DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.isFloatingPointLike(((CastExpr)r).getCastType());
                            DexNumTransformer.this.doBreak = true;
                        } else if (r instanceof InvokeExpr) {
                            DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.isFloatingPointLike(((InvokeExpr)r).getType());
                            DexNumTransformer.this.doBreak = true;
                        } else if (r instanceof LengthExpr) {
                            DexNumTransformer.this.usedAsFloatingPoint = false;
                            DexNumTransformer.this.doBreak = true;
                        } else if (r instanceof Local) {
                            // empty if block
                        }
                    }

                    @Override
                    public void caseIdentityStmt(IdentityStmt stmt) {
                        Debug.printDbg("h", new Object[0]);
                        if (stmt.getLeftOp() == DexNumTransformer.this.l) {
                            DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.isFloatingPointLike(stmt.getRightOp().getType());
                            DexNumTransformer.this.doBreak = true;
                        }
                    }
                });
                if (this.doBreak) break;
                for (UnitValueBoxPair pair : localUses.getUsesOf(u)) {
                    Unit use = pair.getUnit();
                    Debug.printDbg("    use: ", use);
                    use.apply(new AbstractStmtSwitch(){

                        private boolean examineInvokeExpr(InvokeExpr e) {
                            List<Value> args = e.getArgs();
                            List<Type> argTypes = e.getMethodRef().parameterTypes();
                            assert (args.size() == argTypes.size());
                            for (int i = 0; i < args.size(); ++i) {
                                if (args.get(i) != DexNumTransformer.this.l || !DexNumTransformer.this.isFloatingPointLike(argTypes.get(i))) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public void caseInvokeStmt(InvokeStmt stmt) {
                            InvokeExpr e = stmt.getInvokeExpr();
                            DexNumTransformer.this.usedAsFloatingPoint = this.examineInvokeExpr(e);
                        }

                        @Override
                        public void caseAssignStmt(AssignStmt stmt) {
                            ArrayRef ar;
                            Value left = stmt.getLeftOp();
                            if (left instanceof ArrayRef && (ar = (ArrayRef)left).getIndex() == DexNumTransformer.this.l) {
                                DexNumTransformer.this.doBreak = true;
                                return;
                            }
                            Value r = stmt.getRightOp();
                            if (r instanceof ArrayRef) {
                                if (((ArrayRef)r).getIndex() == DexNumTransformer.this.l) {
                                    DexNumTransformer.this.doBreak = true;
                                    return;
                                }
                            } else {
                                if (r instanceof InvokeExpr) {
                                    DexNumTransformer.this.usedAsFloatingPoint = this.examineInvokeExpr((InvokeExpr)r);
                                    DexNumTransformer.this.doBreak = true;
                                    return;
                                }
                                if (r instanceof BinopExpr) {
                                    DexNumTransformer.this.usedAsFloatingPoint = DexNumTransformer.this.examineBinopExpr(stmt);
                                    DexNumTransformer.this.doBreak = true;
                                    return;
                                }
                                if (r instanceof CastExpr) {
                                    DexNumTransformer.this.usedAsFloatingPoint = stmt.hasTag("FloatOpTag") || stmt.hasTag("DoubleOpTag");
                                    DexNumTransformer.this.doBreak = true;
                                    return;
                                }
                                if (left instanceof FieldRef && r instanceof Local && r == DexNumTransformer.this.l) {
                                    FieldRef fr = (FieldRef)left;
                                    if (DexNumTransformer.this.isFloatingPointLike(fr.getType())) {
                                        DexNumTransformer.this.usedAsFloatingPoint = true;
                                    }
                                    DexNumTransformer.this.doBreak = true;
                                    return;
                                }
                            }
                        }

                        @Override
                        public void caseReturnStmt(ReturnStmt stmt) {
                            DexNumTransformer.this.usedAsFloatingPoint = stmt.getOp() == DexNumTransformer.this.l && DexNumTransformer.this.isFloatingPointLike(body.getMethod().getReturnType());
                            Debug.printDbg(" [return stmt] ", stmt, " usedAsObject: ", DexNumTransformer.this.usedAsFloatingPoint, ", return type: ", body.getMethod().getReturnType());
                            Debug.printDbg(" class: ", body.getMethod().getReturnType().getClass());
                            DexNumTransformer.this.doBreak = true;
                        }
                    });
                    if (!this.doBreak) continue;
                    break;
                }
                if (!this.doBreak) continue;
                break;
            }
            if (!this.usedAsFloatingPoint) continue;
            for (Unit u : defs) {
                this.replaceWithFloatingPoint(u);
            }
        }
    }

    protected boolean examineBinopExpr(Unit u) {
        return u.hasTag("FloatOpTag") || u.hasTag("DoubleOpTag");
    }

    private boolean isFloatingPointLike(Type t) {
        return t instanceof FloatType || t instanceof DoubleType;
    }

    private Set<Local> getNumCandidates(Body body) {
        HashSet<Local> candidates = new HashSet<Local>();
        for (Unit u : body.getUnits()) {
            AssignStmt a;
            if (!(u instanceof AssignStmt) || !((a = (AssignStmt)u).getLeftOp() instanceof Local)) continue;
            Local l = (Local)a.getLeftOp();
            Value r = a.getRightOp();
            if (!(r instanceof IntConstant) && !(r instanceof LongConstant)) continue;
            candidates.add(l);
            Debug.printDbg("[add null candidate: ", u);
        }
        return candidates;
    }

    private void replaceWithFloatingPoint(Unit u) {
        if (u instanceof AssignStmt) {
            AssignStmt s = (AssignStmt)u;
            Value v = s.getRightOp();
            if (v instanceof IntConstant) {
                int vVal = ((IntConstant)v).value;
                s.setRightOp(FloatConstant.v(Float.intBitsToFloat(vVal)));
                Debug.printDbg("[floatingpoint] replacing with float in ", u);
            } else if (v instanceof LongConstant) {
                long vVal = ((LongConstant)v).value;
                s.setRightOp(DoubleConstant.v(Double.longBitsToDouble(vVal)));
                Debug.printDbg("[floatingpoint] replacing with double in ", u);
            }
        }
    }
}

