/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.ValueBox;
import soot.tagkit.AbstractHost;
import soot.util.Switch;

public abstract class AbstractUnit
extends AbstractHost
implements Unit {
    List<UnitBox> boxesPointingToThis = null;

    @Override
    public abstract Object clone();

    @Override
    public List<ValueBox> getUseBoxes() {
        return Collections.emptyList();
    }

    @Override
    public List<ValueBox> getDefBoxes() {
        return Collections.emptyList();
    }

    @Override
    public List<UnitBox> getUnitBoxes() {
        return Collections.emptyList();
    }

    @Override
    public List<UnitBox> getBoxesPointingToThis() {
        if (this.boxesPointingToThis == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.boxesPointingToThis);
    }

    @Override
    public void addBoxPointingToThis(UnitBox b) {
        if (this.boxesPointingToThis == null) {
            this.boxesPointingToThis = new ArrayList<UnitBox>();
        }
        this.boxesPointingToThis.add(b);
    }

    @Override
    public void removeBoxPointingToThis(UnitBox b) {
        if (this.boxesPointingToThis != null) {
            this.boxesPointingToThis.remove(b);
        }
    }

    @Override
    public void clearUnitBoxes() {
        for (UnitBox ub : this.getUnitBoxes()) {
            ub.setUnit(null);
        }
    }

    @Override
    public List<ValueBox> getUseAndDefBoxes() {
        List<ValueBox> useBoxes = this.getUseBoxes();
        List<ValueBox> defBoxes = this.getDefBoxes();
        if (useBoxes.isEmpty()) {
            return defBoxes;
        }
        if (defBoxes.isEmpty()) {
            return useBoxes;
        }
        ArrayList<ValueBox> valueBoxes = new ArrayList<ValueBox>();
        valueBoxes.addAll(defBoxes);
        valueBoxes.addAll(useBoxes);
        return valueBoxes;
    }

    @Override
    public void apply(Switch sw) {
    }

    @Override
    public void redirectJumpsToThisTo(Unit newLocation) {
        UnitBox[] boxes;
        List<UnitBox> boxesPointing = this.getBoxesPointingToThis();
        for (UnitBox element : boxes = boxesPointing.toArray(new UnitBox[boxesPointing.size()])) {
            UnitBox box = element;
            if (box.getUnit() != this) {
                throw new RuntimeException("Something weird's happening");
            }
            if (!box.isBranchTarget()) continue;
            box.setUnit(newLocation);
        }
    }
}

