/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import heros.InterproceduralCFG;
import heros.fieldsens.Debugger;
import heros.fieldsens.FactMergeHandler;
import heros.fieldsens.FieldSensitiveIFDSSolver;
import heros.fieldsens.IFDSTabulationProblem;
import heros.fieldsens.MethodAnalyzer;
import heros.fieldsens.Scheduler;
import heros.fieldsens.SourceStmtAnnotatedMethodAnalyzer;
import java.util.Set;

public class BiDiFieldSensitiveIFDSSolver<Field, Fact, Stmt, Method, I extends InterproceduralCFG<Stmt, Method>> {
    private FieldSensitiveIFDSSolver<Field, Fact, Stmt, Method, I> forwardSolver;
    private FieldSensitiveIFDSSolver<Field, Fact, Stmt, Method, I> backwardSolver;
    private Scheduler scheduler;
    private SynchronizerImpl<Stmt> forwardSynchronizer;
    private SynchronizerImpl<Stmt> backwardSynchronizer;

    public BiDiFieldSensitiveIFDSSolver(IFDSTabulationProblem<Stmt, Field, Fact, Method, I> forwardProblem, IFDSTabulationProblem<Stmt, Field, Fact, Method, I> backwardProblem, FactMergeHandler<Fact> factHandler, Debugger<Field, Fact, Stmt, Method> debugger, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.forwardSynchronizer = new SynchronizerImpl();
        this.backwardSynchronizer = new SynchronizerImpl();
        ((SynchronizerImpl)this.forwardSynchronizer).otherSynchronizer = (SynchronizerImpl)this.backwardSynchronizer;
        ((SynchronizerImpl)this.backwardSynchronizer).otherSynchronizer = (SynchronizerImpl)this.forwardSynchronizer;
        this.forwardSolver = this.createSolver(forwardProblem, factHandler, debugger, this.forwardSynchronizer);
        this.backwardSolver = this.createSolver(backwardProblem, factHandler, debugger, this.backwardSynchronizer);
    }

    private FieldSensitiveIFDSSolver<Field, Fact, Stmt, Method, I> createSolver(IFDSTabulationProblem<Stmt, Field, Fact, Method, I> problem, FactMergeHandler<Fact> factHandler, Debugger<Field, Fact, Stmt, Method> debugger, final SynchronizerImpl<Stmt> synchronizer) {
        return new FieldSensitiveIFDSSolver<Field, Fact, Stmt, Method, I>(problem, factHandler, debugger, this.scheduler){

            @Override
            protected MethodAnalyzer<Field, Fact, Stmt, Method> createMethodAnalyzer(Method method) {
                return new SourceStmtAnnotatedMethodAnalyzer(method, this.context, synchronizer, this.debugger);
            }
        };
    }

    private static class SynchronizerImpl<Stmt>
    implements SourceStmtAnnotatedMethodAnalyzer.Synchronizer<Stmt> {
        private SynchronizerImpl<Stmt> otherSynchronizer;
        private Set<Stmt> leakedSources = Sets.newHashSet();
        private HashMultimap<Stmt, Runnable> pausedJobs = HashMultimap.create();

        private SynchronizerImpl() {
        }

        @Override
        public void synchronizeOnStmt(Stmt stmt, Runnable job) {
            this.leakedSources.add(stmt);
            if (this.otherSynchronizer.leakedSources.contains(stmt)) {
                job.run();
                for (Runnable runnable : this.otherSynchronizer.pausedJobs.get((Object)stmt)) {
                    runnable.run();
                }
                this.otherSynchronizer.pausedJobs.removeAll(stmt);
            } else {
                this.pausedJobs.put(stmt, (Object)job);
            }
        }
    }
}

